<?php
Redux::setSection( $opt_name, array(
	'title' => esc_html__('General Options', 'travivu'),
	'icon' => 'el-icon-wrench',
	'fields' => array(
      array(
        'id'      => 'header_settings',
        'type'    => 'info',
        'raw'     => '<h3 class="mb-0">' . esc_html__('Header settings', 'travivu') . '</h3>'
      ),
      array(
        'id'      => 'header_logo', 
        'type'    => 'media',
        'url'     => true,
        'title'   => esc_html__('Logo in header default', 'travivu'), 
        'default' => ''
      ),  
      array(
        'id'      => 'footer_settings',
        'type'    => 'info',
        'raw'     => '<h3 class="mb-0">' . esc_html__('Footer settings', 'travivu') . '</h3>'
      ),
      array(
         'id'        => 'copyright_default',
         'type'      => 'button_set',
         'title'     => esc_html__('Enable/Disable Copyright Text', 'travivu'),
         'options'   => array(
            'yes'    => esc_html__('Enable', 'travivu'),
            'no'     => esc_html__('Disable', 'travivu')
         ),
         'default'   => 'yes'
      ),
      array(
         'id'        => 'copyright_text',
         'type'      => 'editor',
         'title'     => esc_html__('Footer Copyright Text', 'travivu'),
         'default'   => esc_html__('Copyright - 2025 - Company - All rights reserved. Powered by WordPress.', 'travivu')
      ),
      array(
        'id'      => 'page_layout_settings',
        'type'    => 'info',
        'raw'     => '<h3 class="mb-0">' . esc_html__('Page Layout', 'travivu') . '</h3>'
      ),
		array(
			'id'           => 'page_layout',
			'type'         => 'button_set',
			'title'        => esc_html__('Page Layout', 'travivu'),
			'subtitle'     => esc_html__('Select the page layout type', 'travivu'),
			'options'      => array(
				'boxed'     => esc_html__('Boxed', 'travivu'),
				'fullwidth' => esc_html__('Fullwidth', 'travivu')
			),
			'default' => 'fullwidth'
		),
      

		// Breadcrumb Default Settings
		array(
         'id'     => 'breadcrumb_default',
         'type'   => 'info',
         'icon'   => true,
         'raw'    => '<h3 class="mb-0">' . esc_html__('Breadcrumb Settings Without Elementor', 'travivu') . '</h3>',
      ),
		array(
         'id'        => 'breadcrumb_title',
         'type'      => 'button_set',
         'title'     => esc_html__('Breadcrumb Title', 'travivu'),
         'options'   => array(
            1 => esc_html__('Enable', 'travivu'),
            0 => esc_html__('Disable', 'travivu')
         ),
         'default'   => 1
      ),
      array(
         'id'        => 'breadcrumb_padding_top',
         'type'      => 'slider',
         'title'     => esc_html__('Breadcrumb Padding Top', 'travivu'),
         'default'   => 120,
         'min'       => -1,
         'max'       => 500,
         'step'      => 1,
         'display_value' => 'text',
         'desc'		=> esc_html__('-1 is default of the theme', 'travivu')
      ),
      array(
         'id'        => 'breadcrumb_padding_bottom',
         'type'      => 'slider',
         'title'     => esc_html__('Breadcrumb Padding Top', 'travivu'),
         'default'   => 120,
         'min'       => -1,
         'max'       => 500,
         'step'      => 1,
         'display_value' => 'text',
         'desc'		=> esc_html__('-1 is default of the theme', 'travivu')
      ),
      array(
         'id'        => 'breadcrumb_bg_color',
         'type'      => 'color',
         'title'     => esc_html__('Background Overlay Color', 'travivu'),
         'default'   => ''
      ),
      array(
         'id'        => 'breadcrumb_bg_opacity',
         'type'      => 'slider',
         'title'     => esc_html__('Breadcrumb Ovelay Color Opacity', 'travivu'),
         'default'   => 50,
         'min'       => 0,
         'max'       => 100,
         'step'      => 2,
         'display_value' => 'text',
      ),
      array(
         'id'        => 'breadcrumb_bg_image',
         'type'      => 'media',
         'url'       => true,
         'title'     => esc_html__('Breadcrumb Background Image', 'travivu'),
         'default'   => '',
      ),
      array(
         'id'        => 'breadcrumb_text_stype',
         'type'      => 'select',
         'title'     => esc_html__('Breadcrumb Text Stype', 'travivu'),
         'options'   => 
         array(
            'text-light'     => esc_html__('Light', 'travivu'),
            'text-dark'      => esc_html__('Dark', 'travivu')
         ),
         'default' => 'text-light'
      )
	)
));